//+------------------------------------------------------------------------+
//|                                                                        |
//|                                                     PivotsDaily v2.mq4 |
//|                                                                        |
//+------------------------------------------------------------------------+
    
// [19 Apr 2007] : Fixed Monday bug (Skyline) {Contact me if you want to develop your EA at glicci@yahoo}

#property indicator_chart_window
#property indicator_buffers 7
#property indicator_color1 Lime
#property indicator_color2 Blue
#property indicator_color3 Red
#property indicator_color4 Blue
#property indicator_color5 Red
#property indicator_color6 Blue
#property indicator_color7 Red

//---- input parameters
extern int CountBars=300;
//---- buffers
double PBuffer[];
double S1Buffer[];
double R1Buffer[];
double S2Buffer[];
double R2Buffer[];
double S3Buffer[];
double R3Buffer[];
string Pivot="P",Sup1="S 1", Res1="R 1";
string Sup2="S 2", Res2="R 2", Sup3="S 3", Res3="R 3";
int fontsize=10;
double P,S1,R1,S2,R2,S3,R3;
double LastHigh,LastLow,x;

//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- TODO: add your code here

   ObjectDelete("Pivot");
   ObjectDelete("S1");
   ObjectDelete("R1");
   ObjectDelete("S2");
   ObjectDelete("R2");
   ObjectDelete("S3");
   ObjectDelete("R3");   

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   string short_name;

   IndicatorBuffers(7);
//---- indicator line
   SetIndexStyle(0,DRAW_ARROW,2,1,Lime);
   SetIndexArrow(0,158);
   SetIndexStyle(1,DRAW_ARROW,2,1,Blue);
   SetIndexArrow(1,158);
   SetIndexStyle(2,DRAW_ARROW,2,1,Red);
   SetIndexArrow(2,158);
   SetIndexStyle(3,DRAW_ARROW,2,1,Blue);
   SetIndexArrow(3,158);
   SetIndexStyle(4,DRAW_ARROW,2,1,Red);
   SetIndexArrow(4,158);
   SetIndexStyle(5,DRAW_ARROW,2,1,Blue);
   SetIndexArrow(5,158);
   SetIndexStyle(6,DRAW_ARROW,2,1,Red);
   SetIndexArrow(6,158);
    SetIndexBuffer(0,PBuffer);
   SetIndexBuffer(1,S1Buffer);
   SetIndexBuffer(2,R1Buffer);
   SetIndexBuffer(3,S2Buffer);
   SetIndexBuffer(4,R2Buffer);
   SetIndexBuffer(5,S3Buffer);
   SetIndexBuffer(6,R3Buffer);


//---- name for DataWindow and indicator subwindow label
short_name="Pivot";
   IndicatorShortName(short_name);
   SetIndexLabel(0,short_name);
short_name="R1";
   IndicatorShortName(short_name);
   SetIndexLabel(2,short_name);
short_name="R2";
   IndicatorShortName(short_name);
   SetIndexLabel(4,short_name);
short_name="R3";
   IndicatorShortName(short_name);
   SetIndexLabel(6,short_name);
short_name="S1";
   IndicatorShortName(short_name);
   SetIndexLabel(1,short_name);
short_name="S2";
   IndicatorShortName(short_name);
   SetIndexLabel(3,short_name);
short_name="S3";
   IndicatorShortName(short_name);
   SetIndexLabel(5,short_name);


//----
   SetIndexDrawBegin(0,6);
//----
 




//----
   return(0);
  }

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()

  {
   int    counted_bars=IndicatorCounted();

   int limit, i;
//---- indicator calculation
if (counted_bars==0)
{
   x=Period();
   if (x>CountBars) return(-1);
     ObjectCreate("Pivot", OBJ_TEXT, 0, 0,0);
     ObjectSetText("Pivot", "        Pivot",10,"Arial",Lime);
     ObjectCreate("S1", OBJ_TEXT, 0, 0, 0);
     ObjectSetText("S1", "      S1",10,"Arial",Blue);
     ObjectCreate("R1", OBJ_TEXT, 0, 0, 0);
     ObjectSetText("R1", "      R1",10,"Arial",Red);
     ObjectCreate("S2", OBJ_TEXT, 0, 0, 0);
     ObjectSetText("S2", "      S2",10,"Arial",Blue);
     ObjectCreate("R2", OBJ_TEXT, 0, 0, 0);
     ObjectSetText("R2", "      R2",10,"Arial",Red);
     ObjectCreate("S3", OBJ_TEXT, 0, 0, 0);
     ObjectSetText("S3", "      S3",10,"Arial",Blue);
     ObjectCreate("R3", OBJ_TEXT, 0, 0, 0);
     ObjectSetText("R3", "      R3",10,"Arial",Red);
}
   if(counted_bars<0) return(-1);
//---- last counted bar will be recounted
//   if(counted_bars>0) counted_bars--;
   limit=(Bars-counted_bars)-1;



for (i=limit; i>=0;i--)
{ 

if (TimeDayOfWeek(Time[i]) != 0)
{
 if (High[i+1]>LastHigh) LastHigh=High[i+1];
 if (Low[i+1]<LastLow)   LastLow=Low[i+1];
}

if (
    TimeDay(Time[i])!=TimeDay(Time[i+1]) && TimeDayOfWeek(Time[i])!=0
   )
   {
   P=(LastHigh+LastLow+Close[i+1])/3;
   R1 = (2*P)-LastLow;
   S1 = (2*P)-LastHigh;
   R2 = P+(LastHigh - LastLow);
   S2 = P-(LastHigh - LastLow);
   R3 = (2*P)+(LastHigh-(2*LastLow));
   S3 = (2*P)-((2* LastHigh)-LastLow); 
   LastLow=Open[i]; LastHigh=Open[i];

   ObjectMove("Pivot", 0, Time[i],P);
   ObjectMove("S1", 0, Time[i],S1);
   ObjectMove("R1", 0, Time[i],R1);
   ObjectMove("S2", 0, Time[i],S2);
   ObjectMove("R2", 0, Time[i],R2);
   ObjectMove("S3", 0, Time[i],S3);
   ObjectMove("R3", 0, Time[i],R3);

   }
   
    PBuffer[i]=P;
    S1Buffer[i]=S1;
    R1Buffer[i]=R1;
    S2Buffer[i]=S2;
    R2Buffer[i]=R2;
    S3Buffer[i]=S3;
    R3Buffer[i]=R3;
//Comment("R3=",R3Buffer[i],"\n","R2=",R2Buffer[i],"\n","R1=",R1Buffer[i],"\n","Pivot=",PBuffer[i],"\n","S1=",S1Buffer[i],"\n","S2=",S2Buffer[i],"\n","S3=",S3Buffer[i]);
}

//----
   return(0);
  }
//+------------------------------------------------------------------+